package gov.va.med.mhv.usermgmt.form;

import gov.va.med.mhv.usermgmt.transfer.InPersonAuthenticationCriteria;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;
import org.tigris.atlas.messages.Messages;
import org.tigris.atlas.validate.SsnValidator;

/**
 * The IPACriteriaForm class is responsible for handling user input.
 */
@SuppressWarnings("serial")
public class IPACriteriaForm extends IPACriteriaBaseForm {

	private static final Pattern pattern = Pattern.compile(
        "^[A-Za-z][0-9][0-9][0-9][0-9]$");
	
	private String ssnFieldLevelErrorMessage;
	private String toDateRangeFieldLevelErrorMessage;
	private String dateRangeFieldLevelErrorMessage;

    private static boolean isTrue(String value) {
        return Boolean.parseBoolean(value);
    }

	protected void doReset(ActionMapping mapping, HttpServletRequest request) {
		setSsn1(null);
		setSsn2(null);
		setSsn3(null);
		setAuthenticatingFacilityId(null);
		setTreatingFacilityId(null);
		ssnFieldLevelErrorMessage = null;
		dateRangeFieldLevelErrorMessage = null;
		toDateRangeFieldLevelErrorMessage = null;
	}

	public void copyTrimmedStringsToCriteria(
        InPersonAuthenticationCriteria criteria)
    {
		if (getIpaFirstName() !=null){
			criteria.setFirstName(getIpaFirstName().trim());
		}
		if (getIpaLastName() !=null){
			criteria.setLastName(getIpaLastName().trim());
		}
		if (getIpaEmail() !=null){
			criteria.setEmail(getIpaEmail().trim());
		}
		if (getIpaFirstPlusFour() !=null){
			criteria.setFirstPlusFour(getIpaFirstPlusFour().trim());
		}
		if (getIpaMhvId() !=null){
			criteria.setMhvId(getIpaMhvId().trim());
		}
		if (getIpaUsername() !=null){
			criteria.setUsername(getIpaUsername().trim());
		}
	}
	public String getFormattedSsn(){
		if (!StringUtils.isBlank(getSsn1()) && !StringUtils.isBlank(getSsn2()) 
            && !StringUtils.isBlank(getSsn3())) 
        {
			StringBuffer ssn = new StringBuffer(11);
			ssn.append(getSsn1());
			ssn.append("-");
			ssn.append(getSsn2());
			ssn.append("-");
			ssn.append(getSsn3());
			return ssn.toString();
		}
		return "";
	}
	
	public void copySsnToCriteria(InPersonAuthenticationCriteria criteria) {
		String ssn = getFormattedSsn();
		if (!StringUtils.isBlank(ssn)){
			criteria.setSsn(ssn.toString());
		} else {
			criteria.setSsn(null);
		}
	}
	
	public void copyFacilityToCriteria(
        InPersonAuthenticationCriteria criteria) 
    {
		String authFacility = getAuthenticatingFacilityId();
		String treatFacility = getTreatingFacilityId();
		
		if (!StringUtils.isBlank(authFacility)) {
			criteria.setAuthenticatingFacilityInfoId(Long.parseLong(
                authFacility));
		} else {
			criteria.setAuthenticatingFacilityInfoId(null);
		}
		
		if (!StringUtils.isBlank(treatFacility)) {
			criteria.setTreatingFacilityId(Long.parseLong(treatFacility));
		} else {
			criteria.setTreatingFacilityId(null);
		}
	}

	protected void additionalValidation(HttpServletRequest request) {
		super.additionalValidation(request);
		
		String firstPlusFour = getIpaFirstPlusFour();
		if (!StringUtils.isBlank(firstPlusFour)) {
			Matcher m = pattern.matcher(firstPlusFour);
			if (!m.matches()) {
				Message errMsg = MessageUtils.createErrorMessage(
                    "invalid.first.plus.four", new String [] {"firstPlusFour"}, 
                    null);
				getMessages().addMessage(errMsg);
			}
		}
		StringBuffer ssn = new StringBuffer(10);
		String ssn1 = StringUtils.isBlank(getSsn1()) ? "" : getSsn1();
		ssn.append(ssn1);
		
		if(!StringUtils.isBlank(getSsn2())){
			if(!StringUtils.isBlank(getSsn1())){
				ssn.append("-");
			}
			ssn.append(getSsn2());
		}
		if(!StringUtils.isBlank(getSsn3())){
			if(!StringUtils.isBlank(getSsn2()) || (StringUtils.isBlank(
                getSsn2()) && !StringUtils.isBlank(getSsn1())))
            {
				ssn.append("-");
			}
			ssn.append(getSsn3());
		}
		
		if (!StringUtils.isBlank(ssn.toString())) {
			SsnValidator validator = new SsnValidator();
			Messages msgs = validator.validate(ssn.toString(), 
                new String [] {"ssn"}, new Object [] {ssn.toString()});
			getMessages().addMessages(msgs);	
		}
		
		if(!getMessages().hasErrorMessages() && isEmpty()){
			Message errMsg = MessageUtils.createErrorMessage(
                "empty.search.critiera", null, null);
			getMessages().addMessage(errMsg);
		}
		
		setFieldLevelErrorMessages(getMessages(), request);
		setMyFieldLevelErrorMessages(getMessages(), request);
	}

	private void setMyFieldLevelErrorMessages(Messages messages, 
        HttpServletRequest request) 
    {
		if (getMessages().getErrorMessageCount("ssn") > 0) {
			Message message = (Message) messages.getErrorMessages("ssn").
            iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			ssnFieldLevelErrorMessage = errorString;
		}
		if (getMessages().getErrorMessageCount("fromAuthenticationDate") > 0) {
			Message message = (Message) messages.getErrorMessages(
                "fromAuthenticationDate").iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			dateRangeFieldLevelErrorMessage = errorString;
		} 
		if (getMessages().getErrorMessageCount("toAuthenticationDate") > 0) {
			Message message = (Message) messages.getErrorMessages(
                "toAuthenticationDate").iterator().next();
			String errorString = getFieldLevelMessage(message, request);
			toDateRangeFieldLevelErrorMessage = errorString;
		}
	}

	public String getDateRangeErrorMessage() {
		return dateRangeFieldLevelErrorMessage;
	}

	public String getToDateRangeErrorMessage() {
		return toDateRangeFieldLevelErrorMessage;
	}
	
	public String getSsnFieldLevelErrorMessage() {
		return ssnFieldLevelErrorMessage;
	}

	
	public boolean isEmpty(){
		return 
            StringUtils.isBlank(getIpaFirstPlusFour()) &&
			StringUtils.isBlank(getIpaUsername()) &&
			StringUtils.isBlank(getIpaFirstName()) &&
			//MHV_CodeCR1386 - Make sure that when the middle name is entered, it will be recognized as criteria not empty
			StringUtils.isBlank(getIpaMiddleName()) &&
			StringUtils.isBlank(getIpaLastName()) &&
			StringUtils.isBlank(getIpaEmail()) &&
			StringUtils.isBlank(getFormattedSsn()) &&
			StringUtils.isBlank(getIpaDateOfBirthYear()) &&
			StringUtils.isBlank(getIpaMhvId()) &&
			!isTrue(getIpaStatusAuthenticated()) && 
            !isTrue(getIpaStatusUnauthenticated()) && 
            !isTrue(getIpaStatusInProcess()) && 
            !isTrue(getIpaStatusPrerequisitesComplete()) && 
            !isTrue(getIpaStatusPendingAuthentication()) && 
            !isTrue(getIpaStatusPendingUnauthentication()) &&
            !isTrue(getIpaStatusPendingFailed()) && 
            !isTrue(getIpaStatusPendingDataMismatch()) &&
            
            //MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - Adding Correlation status checks 
            !isTrue(getIpaStatusMatched()) && 
            !isTrue(getIpaStatusUnmatched()) && 
            !isTrue(getIpaStatusCorrelated()) && 
            !isTrue(getIpaStatusPendingCorrelation()) && 
            !isTrue(getIpaStatusUncorrelated()) && 
            !isTrue(getIpaStatusPendingUncorrelated()) &&
            !isTrue(getIpaStatusFailedCorrelation()) &&
            !isTrue(getIpaStatusFailedUncorrelation()) &&
            !isTrue(getIpaStatusCorrelationInvalid()) &&
			
            StringUtils.isBlank(getIpaFromAuthenticationDateYear()) &&
			StringUtils.isBlank(getTreatingFacilityId()) &&
			StringUtils.isBlank(getAuthenticatingFacilityId());
	}
    
}